#lang racket

(define (teleportation-spell grid)
  (define m (length grid))
  (define n (if (zero? m) 0 (length (car grid))))
  (define visited (make-hash))
  (define q (queue))
  (define dirs '((0 . 1) (1 . 0) (0 . -1) (-1 . 0)))

  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (when (equal? (list-ref (list-ref grid i) j) 'S)
        (hash-set! visited (cons i j) #t)
        (enqueue! q (cons i j))))

  (define steps 0)
  (let loop ()
    (unless (queue-empty? q)
      (define size (queue-length q))
      (for ([_ (in-range size)])
        (define pos (dequeue! q))
        (define i (car pos))
        (define j (cdr pos))
        (when (equal? (list-ref (list-ref grid i) j) 'T)
          (return steps))
        (for ([dir dirs])
          (define ni (+ i (car dir)))
          (define nj (+ j (cdr dir)))
          (when (and (>= ni 0) (< ni m) (>= nj 0) (< nj n))
            (define cell (list-ref (list-ref grid ni) nj))
            (unless (or (equal? cell '#) (hash-has-key? visited (cons ni nj)))
              (hash-set! visited (cons ni nj) #t)
              (enqueue! q (cons ni nj)))))
      (set! steps (add1 steps))
      (loop)))
  -1)